# -*- coding: utf-8 -*-
"""Untitled27.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1B9SZoZrU-cBPcNbOTgAVuCVQKlpso2-R
"""

# ==============================================================================
# MAIN EXECUTION FIGURE 4
# ==============================================================================
import numpy as np
import matrix_product_approximations_exp4 as malib # Import the library

if __name__ == "__main__":
    # Parameters for Experiment 4
    n_exp4 = 200
    m_exp4 = 30
    p_exp4 = 50
    k_fractions_exp4 = [0.05, 0.1, 0.2]
    k_values_exp4 = sorted(list(set([max(1, int(frac * n_exp4)) for frac in k_fractions_exp4])))

    # Target Rho_G values for the experiment
    target_rho_values_exp4 = [1.0, 4.0, 12.0, 25.0, 50.0, 100.0, 250.0]

    n_trials_exp4 = 30  # Number of trials for randomized algorithms
    base_seed_exp4 = 42 # Base seed for reproducibility

    # Run Experiment 4: Impact of ρG on Approximation Error
    exp4_results = malib.run_experiment_rho_vs_error(
        target_rho_list=target_rho_values_exp4,
        n_dim=n_exp4,
        m_dim=m_exp4,
        p_dim=p_exp4,
        k_values=k_values_exp4,
        n_trials=n_trials_exp4,
        base_seed=base_seed_exp4
    )

    # Save and plot results if any were generated
    if exp4_results:
        malib.save_results_to_json(
            results_data=exp4_results,
            n_dim=n_exp4,
            k_values_list=k_values_exp4,
            filename_prefix="experiment4_rho_impact" # Updated prefix for Exp4
        )
        malib.plot_rho_vs_error_multi_k(
            results_data=exp4_results,
            n_dim=n_exp4,
            k_values=k_values_exp4,
            styles=malib.IMPROVED_STYLES # Use styles from the library
        )
        print("\nExperiment 4 (Impact of ρG) completed successfully!")
    else:
        print("\nExperiment 4 (Impact of ρG) yielded no results to save or plot.")

    print("\nAll requested experiments completed!")

